/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type GetExerciseVariables = _Types.Exact<{
  exerciseId: _Types.Scalars['ID']['input'];
}>;


export type GetExercise = { exerciseId: { id: string, name: string, running: boolean, finished: boolean, exerciseStart: string | null, timeDelta: number, definition: { id: number | null, name: string | null } | null, teams: Array<{ id: string, name: string, role: string, emailAddress: { id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null } | null, exercise: { id: string, name: string }, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null }>, emailParticipants: Array<{ id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null }>, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null } | null };


export const GetExerciseDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"GetExercise"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exerciseId"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"exerciseId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"exerciseId"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Exercise"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Exercise"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"running"}},{"kind":"Field","name":{"kind":"Name","value":"finished"}},{"kind":"Field","name":{"kind":"Name","value":"exerciseStart"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseDefinition"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teams"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Team"}}]}},{"kind":"Field","name":{"kind":"Name","value":"emailParticipants"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","alias":{"kind":"Name","value":"timeDelta"},"name":{"kind":"Name","value":"elapsedS"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ExerciseDefinition"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseDefinitionType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Team"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}},{"kind":"Field","name":{"kind":"Name","value":"emailAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","name":{"kind":"Name","value":"exercise"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailParticipant"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailParticipantType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"definitionAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailAddress"}}]}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"team"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"TeamWithoutEmailAddress"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailAddressType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"description"}},{"kind":"Field","name":{"kind":"Name","value":"control"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Control"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teamVisible"}},{"kind":"Field","name":{"kind":"Name","value":"organization"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Control"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ControlType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"milestoneCondition"}},{"kind":"Field","name":{"kind":"Name","value":"activateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"deactivateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"TeamWithoutEmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"RestrictedUser"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"RestrictedUser"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"username"}},{"kind":"Field","name":{"kind":"Name","value":"firstName"}},{"kind":"Field","name":{"kind":"Name","value":"lastName"}},{"kind":"Field","name":{"kind":"Name","value":"group"}}]}}]} as unknown as DocumentNode;

/**
 * __useGetExercise__
 *
 * To run a query within a React component, call `useGetExercise` and pass it any options that fit your needs.
 * When your component renders, `useGetExercise` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetExercise({
 *   variables: {
 *      exerciseId: // value for 'exerciseId'
 *   },
 * });
 */
export function useGetExercise(baseOptions: Apollo.QueryHookOptions<GetExercise, GetExerciseVariables> & ({ variables: GetExerciseVariables; skip?: boolean; } | { skip: boolean; }) ) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetExercise, GetExerciseVariables>(GetExerciseDocument, options);
      }
export function useGetExerciseLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetExercise, GetExerciseVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetExercise, GetExerciseVariables>(GetExerciseDocument, options);
        }
export function useGetExerciseSuspenseQuery(baseOptions?: Apollo.SuspenseQueryHookOptions<GetExercise, GetExerciseVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useSuspenseQuery<GetExercise, GetExerciseVariables>(GetExerciseDocument, options);
        }
export type GetExerciseHookResult = ReturnType<typeof useGetExercise>;
export type GetExerciseLazyQueryHookResult = ReturnType<typeof useGetExerciseLazyQuery>;
export type GetExerciseSuspenseQueryHookResult = ReturnType<typeof useGetExerciseSuspenseQuery>;
export type GetExerciseQueryResult = Apollo.QueryResult<GetExercise, GetExerciseVariables>;