/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type GetEmailThreadVariables = _Types.Exact<{
  threadId: _Types.Scalars['ID']['input'];
}>;


export type GetEmailThread = { emailThread: { id: string, subject: string, timestamp: string, participants: Array<{ id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null }>, emails: Array<{ id: string, timestamp: string, readReceipt: string | null, sender: { id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null }, thread: { id: string }, content: { id: string, raw: string, rendered: string, fileInfo: { id: any, fileName: string } | null }, overlay: { id: string, duration: number } | null }>, lastEmail: { id: string, timestamp: string, readReceipt: string | null, sender: { id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null }, thread: { id: string }, content: { id: string, raw: string, rendered: string, fileInfo: { id: any, fileName: string } | null }, overlay: { id: string, duration: number } | null } | null, readReceipt: Array<{ isUnread: boolean | null, teamId: string }> } | null };


export const GetEmailThreadDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"GetEmailThread"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"threadId"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"emailThread"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"threadId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"threadId"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailThread"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailThread"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailThreadType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"participants"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","name":{"kind":"Name","value":"subject"}},{"kind":"Field","name":{"kind":"Name","value":"timestamp"}},{"kind":"Field","name":{"kind":"Name","value":"emails"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Email"}}]}},{"kind":"Field","name":{"kind":"Name","value":"lastEmail"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Email"}}]}},{"kind":"Field","name":{"kind":"Name","value":"readReceipt"},"directives":[{"kind":"Directive","name":{"kind":"Name","value":"client"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"always"},"value":{"kind":"BooleanValue","value":true}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"isUnread"}},{"kind":"Field","name":{"kind":"Name","value":"teamId"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailParticipant"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailParticipantType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"definitionAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailAddress"}}]}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"team"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"TeamWithoutEmailAddress"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailAddressType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"description"}},{"kind":"Field","name":{"kind":"Name","value":"control"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Control"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teamVisible"}},{"kind":"Field","name":{"kind":"Name","value":"organization"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Control"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ControlType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"milestoneCondition"}},{"kind":"Field","name":{"kind":"Name","value":"activateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"deactivateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"TeamWithoutEmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Email"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"sender"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","name":{"kind":"Name","value":"thread"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}}]}},{"kind":"Field","name":{"kind":"Name","value":"content"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Content"}}]}},{"kind":"Field","name":{"kind":"Name","value":"overlay"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Overlay"}}]}},{"kind":"Field","name":{"kind":"Name","value":"timestamp"}},{"kind":"Field","name":{"kind":"Name","value":"readReceipt"},"directives":[{"kind":"Directive","name":{"kind":"Name","value":"client"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"always"},"value":{"kind":"BooleanValue","value":true}}]}]}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Content"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ContentType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"raw"}},{"kind":"Field","name":{"kind":"Name","value":"rendered"}},{"kind":"Field","name":{"kind":"Name","value":"fileInfo"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"FileInfo"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"FileInfo"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"FileInfoType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"fileName"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Overlay"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"OverlayType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"duration"}}]}}]} as unknown as DocumentNode;

/**
 * __useGetEmailThread__
 *
 * To run a query within a React component, call `useGetEmailThread` and pass it any options that fit your needs.
 * When your component renders, `useGetEmailThread` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetEmailThread({
 *   variables: {
 *      threadId: // value for 'threadId'
 *   },
 * });
 */
export function useGetEmailThread(baseOptions: Apollo.QueryHookOptions<GetEmailThread, GetEmailThreadVariables> & ({ variables: GetEmailThreadVariables; skip?: boolean; } | { skip: boolean; }) ) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useQuery<GetEmailThread, GetEmailThreadVariables>(GetEmailThreadDocument, options);
      }
export function useGetEmailThreadLazyQuery(baseOptions?: Apollo.LazyQueryHookOptions<GetEmailThread, GetEmailThreadVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useLazyQuery<GetEmailThread, GetEmailThreadVariables>(GetEmailThreadDocument, options);
        }
export function useGetEmailThreadSuspenseQuery(baseOptions?: Apollo.SuspenseQueryHookOptions<GetEmailThread, GetEmailThreadVariables>) {
          const options = {...defaultOptions, ...baseOptions}
          return Apollo.useSuspenseQuery<GetEmailThread, GetEmailThreadVariables>(GetEmailThreadDocument, options);
        }
export type GetEmailThreadHookResult = ReturnType<typeof useGetEmailThread>;
export type GetEmailThreadLazyQueryHookResult = ReturnType<typeof useGetEmailThreadLazyQuery>;
export type GetEmailThreadSuspenseQueryHookResult = ReturnType<typeof useGetEmailThreadSuspenseQuery>;
export type GetEmailThreadQueryResult = Apollo.QueryResult<GetEmailThread, GetEmailThreadVariables>;