/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type LoginVariables = _Types.Exact<{
  username: _Types.Scalars['String']['input'];
  password: _Types.Scalars['String']['input'];
}>;


export type Login = { login: { user: { id: any, lastLogin: string | null, username: string, firstName: string | null, lastName: string | null, dateJoined: string, group: _Types.AuthGroup | null, isActive: boolean, isImported: boolean, tags: Array<{ id: string, name: string }>, teams: Array<{ id: string, name: string, role: string, exercise: { id: string, name: string, running: boolean, finished: boolean, exerciseStart: string | null, timeDelta: number, definition: { id: number | null, name: string | null } | null, teams: Array<{ id: string, name: string, role: string, emailAddress: { id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null } | null, exercise: { id: string, name: string }, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null }>, emailParticipants: Array<{ id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null }>, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null } } | null> | null, exercises: Array<{ id: string, name: string } | null> | null, definitions: Array<{ id: number | null, name: string | null } | null> | null } | null } | null };


export const LoginDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"mutation","name":{"kind":"Name","value":"Login"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"username"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"password"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"login"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"username"},"value":{"kind":"Variable","name":{"kind":"Name","value":"username"}}},{"kind":"Argument","name":{"kind":"Name","value":"password"},"value":{"kind":"Variable","name":{"kind":"Name","value":"password"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"user"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"User"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"User"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"UserType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"lastLogin"}},{"kind":"Field","name":{"kind":"Name","value":"username"}},{"kind":"Field","name":{"kind":"Name","value":"firstName"}},{"kind":"Field","name":{"kind":"Name","value":"lastName"}},{"kind":"Field","name":{"kind":"Name","value":"dateJoined"}},{"kind":"Field","name":{"kind":"Name","value":"group"}},{"kind":"Field","name":{"kind":"Name","value":"isActive"}},{"kind":"Field","name":{"kind":"Name","value":"isImported"}},{"kind":"Field","name":{"kind":"Name","value":"tags"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Tag"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teams"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedTeam"}}]}},{"kind":"Field","name":{"kind":"Name","value":"exercises"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedExercise"}}]}},{"kind":"Field","name":{"kind":"Name","value":"definitions"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseDefinition"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Tag"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TagType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"RestrictedTeam"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"RestrictedTeam"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"exercise"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Exercise"}}]}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Exercise"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"running"}},{"kind":"Field","name":{"kind":"Name","value":"finished"}},{"kind":"Field","name":{"kind":"Name","value":"exerciseStart"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseDefinition"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teams"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Team"}}]}},{"kind":"Field","name":{"kind":"Name","value":"emailParticipants"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","alias":{"kind":"Name","value":"timeDelta"},"name":{"kind":"Name","value":"elapsedS"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ExerciseDefinition"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseDefinitionType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Team"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}},{"kind":"Field","name":{"kind":"Name","value":"emailAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","name":{"kind":"Name","value":"exercise"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailParticipant"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailParticipantType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"definitionAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailAddress"}}]}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"team"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"TeamWithoutEmailAddress"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailAddressType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"description"}},{"kind":"Field","name":{"kind":"Name","value":"control"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Control"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teamVisible"}},{"kind":"Field","name":{"kind":"Name","value":"organization"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Control"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ControlType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"milestoneCondition"}},{"kind":"Field","name":{"kind":"Name","value":"activateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"deactivateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"TeamWithoutEmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"RestrictedUser"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"RestrictedUser"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"username"}},{"kind":"Field","name":{"kind":"Name","value":"firstName"}},{"kind":"Field","name":{"kind":"Name","value":"lastName"}},{"kind":"Field","name":{"kind":"Name","value":"group"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"RestrictedExercise"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"RestrictedExercise"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}}]} as unknown as DocumentNode;
export type LoginMutationFn = Apollo.MutationFunction<Login, LoginVariables>;

/**
 * __useLogin__
 *
 * To run a mutation, you first call `useLogin` within a React component and pass it any options that fit your needs.
 * When your component renders, `useLogin` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [login, { data, loading, error }] = useLogin({
 *   variables: {
 *      username: // value for 'username'
 *      password: // value for 'password'
 *   },
 * });
 */
export function useLogin(baseOptions?: Apollo.MutationHookOptions<Login, LoginVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<Login, LoginVariables>(LoginDocument, options);
      }
export type LoginHookResult = ReturnType<typeof useLogin>;
export type LoginMutationResult = Apollo.MutationResult<Login>;
export type LoginMutationOptions = Apollo.BaseMutationOptions<Login, LoginVariables>;