/* eslint-disable */
//@ts-nocheck
import type * as _Types from '../types';

import type { DocumentNode } from 'graphql';
import * as Apollo from '@apollo/client';
const defaultOptions = {} as const;
export type CreateExercisesVariables = _Types.Exact<{
  id: _Types.Scalars['ID']['input'];
  teamCount: _Types.Scalars['Int']['input'];
  name: _Types.InputMaybe<_Types.Scalars['String']['input']>;
}>;


export type CreateExercises = { createExercise: { exercise: { id: string, name: string, running: boolean, finished: boolean, exerciseStart: string | null, timeDelta: number, definition: { id: number | null, name: string | null } | null, teams: Array<{ id: string, name: string, role: string, emailAddress: { id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null } | null, exercise: { id: string, name: string }, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null }>, emailParticipants: Array<{ id: string, address: string, definitionAddress: { id: string, address: string, description: string, teamVisible: boolean, organization: string, control: { id: string, milestoneCondition: string, activateMilestone: string, deactivateMilestone: string, roles: string } } | null, team: { id: string, name: string, role: string } | null }>, userSet: Array<{ id: any, username: string, firstName: string | null, lastName: string | null, group: _Types.AuthGroup | null } | null> | null } | null } | null };


export const CreateExercisesDocument = /*#__PURE__*/ {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"mutation","name":{"kind":"Name","value":"CreateExercises"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"id"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"ID"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"teamCount"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"Int"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"createExercise"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"createExerciseInput"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"definitionId"},"value":{"kind":"Variable","name":{"kind":"Name","value":"id"}}},{"kind":"ObjectField","name":{"kind":"Name","value":"teamCount"},"value":{"kind":"Variable","name":{"kind":"Name","value":"teamCount"}}},{"kind":"ObjectField","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exercise"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Exercise"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Exercise"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"running"}},{"kind":"Field","name":{"kind":"Name","value":"finished"}},{"kind":"Field","name":{"kind":"Name","value":"exerciseStart"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ExerciseDefinition"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teams"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Team"}}]}},{"kind":"Field","name":{"kind":"Name","value":"emailParticipants"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","alias":{"kind":"Name","value":"timeDelta"},"name":{"kind":"Name","value":"elapsedS"}},{"kind":"Field","name":{"kind":"Name","value":"definition"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ExerciseDefinition"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ExerciseDefinitionType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Team"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}},{"kind":"Field","name":{"kind":"Name","value":"emailAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailParticipant"}}]}},{"kind":"Field","name":{"kind":"Name","value":"exercise"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"userSet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"RestrictedUser"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailParticipant"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailParticipantType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"definitionAddress"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"EmailAddress"}}]}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"team"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"TeamWithoutEmailAddress"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"EmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"EmailAddressType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"address"}},{"kind":"Field","name":{"kind":"Name","value":"description"}},{"kind":"Field","name":{"kind":"Name","value":"control"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"Control"}}]}},{"kind":"Field","name":{"kind":"Name","value":"teamVisible"}},{"kind":"Field","name":{"kind":"Name","value":"organization"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"Control"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"ControlType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"milestoneCondition"}},{"kind":"Field","name":{"kind":"Name","value":"activateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"deactivateMilestone"}},{"kind":"Field","name":{"kind":"Name","value":"roles"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"TeamWithoutEmailAddress"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"TeamType"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"role"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"RestrictedUser"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"RestrictedUser"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"username"}},{"kind":"Field","name":{"kind":"Name","value":"firstName"}},{"kind":"Field","name":{"kind":"Name","value":"lastName"}},{"kind":"Field","name":{"kind":"Name","value":"group"}}]}}]} as unknown as DocumentNode;
export type CreateExercisesMutationFn = Apollo.MutationFunction<CreateExercises, CreateExercisesVariables>;

/**
 * __useCreateExercises__
 *
 * To run a mutation, you first call `useCreateExercises` within a React component and pass it any options that fit your needs.
 * When your component renders, `useCreateExercises` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [createExercises, { data, loading, error }] = useCreateExercises({
 *   variables: {
 *      id: // value for 'id'
 *      teamCount: // value for 'teamCount'
 *      name: // value for 'name'
 *   },
 * });
 */
export function useCreateExercises(baseOptions?: Apollo.MutationHookOptions<CreateExercises, CreateExercisesVariables>) {
        const options = {...defaultOptions, ...baseOptions}
        return Apollo.useMutation<CreateExercises, CreateExercisesVariables>(CreateExercisesDocument, options);
      }
export type CreateExercisesHookResult = ReturnType<typeof useCreateExercises>;
export type CreateExercisesMutationResult = Apollo.MutationResult<CreateExercises>;
export type CreateExercisesMutationOptions = Apollo.BaseMutationOptions<CreateExercises, CreateExercisesVariables>;