import { createContext, useContext } from 'react'

interface SubscriptionContextProps {
  subscribeTeam: (teamIds: Array<string>) => () => void
  enableInstructorContext: () => void
  disableInstructorContext: () => void
  instructorContext: boolean
  teamIds: string[]
}

export const SubscriptionContext = createContext<SubscriptionContextProps>({
  subscribeTeam: () => () => {},
  enableInstructorContext: () => {},
  disableInstructorContext: () => {},
  instructorContext: false,
  teamIds: [],
})

export const SubscriptionProvider = SubscriptionContext.Provider
export const SubscriptionConsumer = SubscriptionContext.Consumer
export const useSubscriptionContext = () => useContext(SubscriptionContext)
