import { Dialog, DialogBody } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { dialog } from '@inject/shared/css/dialog'
import type { FC } from 'react'

const body = css`
  display: flex;
  flex-direction: column;
  gap: 1rem;
`
interface ErrorDialogInterface {
  host: string
}

const ErrorDialog: FC<ErrorDialogInterface> = ({ host: host_ }) => (
  <Dialog
    className={dialog}
    title='Connection error'
    icon='error'
    isOpen
    canOutsideClickClose={false}
    canEscapeKeyClose={false}
    isCloseButtonShown={false}
  >
    <DialogBody className={body}>
      <p>
        Unable to connect to server located at <code>{host_}</code>.
      </p>
      <p>Please verify if the Backend server is running</p>
    </DialogBody>
  </Dialog>
)

export default ErrorDialog
