import { NetworkStatus as INetworkStatus } from '@apollo/client'

const NetworkStatusSwitch = (status: INetworkStatus) => {
  switch (status) {
    case INetworkStatus.ready:
      return 'Ready'
    case INetworkStatus.error:
      return 'Error'
    case INetworkStatus.loading:
      return 'Loading'
    case INetworkStatus.poll:
      return 'Poll'
    case INetworkStatus.refetch:
      return 'Refetch'
    case INetworkStatus.setVariables:
      return 'SetVariables'
    case INetworkStatus.fetchMore:
      return 'FetchMore'
    default:
      return 'Unknown'
  }
}

const NetworkStatus = ({ status }: { status: INetworkStatus }) => (
  <span>{NetworkStatusSwitch(status)}</span>
)

export default NetworkStatus
