import type { FC } from 'react'
import { memo } from 'react'
import useTeamMilestonesSubscription from '../../../utils/useTeamMilestonesSubscription'
import { hidden } from './classes'

interface TeamInjectServiceProps {
  teamId: string
}

const TeamInjectService: FC<TeamInjectServiceProps> = ({ teamId }) => {
  const { networkStatus } = useTeamMilestonesSubscription(teamId)
  return (
    <div className={hidden}>
      {networkStatus}
      {teamId}
    </div>
  )
}

export default memo(TeamInjectService)
