import type { FC, ReactNode } from 'react'
import { memo } from 'react'
import type { ActionLog } from '../../../fragments/ActionLog.generated'
import useActionLogSubscription from '../../../utils/useActionLogSubscription'
import { hidden } from './classes'

interface SubscriptionServiceProps {
  teamId: string
  showNotifications?: boolean
  getPopup?: (actionLog: ActionLog) => ReactNode
}

const SubscriptionService: FC<SubscriptionServiceProps> = ({
  teamId,
  showNotifications,
  getPopup,
}) => {
  const { networkStatus } = useActionLogSubscription({
    teamId,
    showNotifications,
    getPopup,
  })
  return (
    <div className={hidden}>
      {networkStatus}
      {teamId}
    </div>
  )
}

export default memo(SubscriptionService)
