import type { FC } from 'react'
import { memo } from 'react'
import useEmailThreadSubscription from '../../../utils/useEmailThreadSubscription'
import { hidden } from './classes'

interface SubscriptionServiceProps {
  teamId: string
  selectedThreadId?: string
}

const EmailService: FC<SubscriptionServiceProps> = ({
  teamId,
  selectedThreadId,
}) => {
  const { networkStatus } = useEmailThreadSubscription(teamId, selectedThreadId)
  return (
    <div className={hidden}>
      {networkStatus}
      {teamId}
    </div>
  )
}

export default memo(EmailService)
