import { onError } from '@apollo/client/link/error'
import type { useNotifyContext } from '@inject/shared/notification/contexts/NotifyContext'

const errorLink = (notify: ReturnType<typeof useNotifyContext>['notify']) =>
  onError(({ networkError }) => {
    if (networkError) {
      notify(`Network error: ${networkError.message}`, { intent: 'danger' })
    }
  })

export default errorLink
