import { useIdentity } from '../queries/Identity.generated'

export const useAuthIdentity = () => {
  const { data, loading } = useIdentity()
  const { id, isActive, group } = data?.whoAmI ?? {}

  return {
    id,
    isActive,
    isStaff: group === 'ADMIN' || group === 'INSTRUCTOR',
    isSuperuser: group === 'ADMIN',
    isLogged: !!data?.whoAmI,
    loading,
    whoAmI: data?.whoAmI,
  }
}

export default useAuthIdentity
