import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react-swc'
import generouted from '@generouted/react-router/plugin'
import path from 'path'
import { visualizer } from 'rollup-plugin-visualizer'
import svgr from 'vite-plugin-svgr'
import { vitePluginGraphqlLoader } from 'vite-plugin-graphql-loader'
import * as child_process from 'child_process'
import license from 'rollup-plugin-license'

// https://vitejs.dev/config/
export default () => {
  console.log('Compiling for these env variables: ', process.env)

  return defineConfig({
    esbuild: {
      drop: ['console'],
    },
    plugins: [
      react({
        jsxImportSource: '@emotion/react',
        plugins: [['@swc/plugin-emotion', {}]],
        tsDecorators: true,
        devTarget: 'es2022',
      }),
      generouted(),
      //@ts-ignore
      visualizer(),
      license({
        sourcemap: true,
        cwd: process.cwd(), // The default
  
        banner: {
          commentStyle: 'regular', // The default
  
          content: {
            file: path.join(__dirname, 'LICENSE'),
            encoding: 'utf-8', // Default is utf-8
          },
        },
  
        thirdParty: {
          includePrivate: true, // Default is false.
          multipleVersions: true, // Default is false.
          output: {
            file: path.join(__dirname, 'ThirdPartyLicense.txt'),
            encoding: 'utf-8', // Default is utf-8.
          },
        },
      }),
      vitePluginGraphqlLoader(),
      svgr({
        svgrOptions: {
          ref: true,
        },
      }),
    ],
    envPrefix: ['VITE_', 'INJECT_'],
    resolve: {
      alias: {
        '@': path.resolve(__dirname, './src'),
      },
    },
    define: {
      'globalThis.__DEV__': JSON.stringify(false),
    },
    css: {
      devSourcemap: true,
      modules: {
        localsConvention: 'camelCaseOnly',
      },
    },
    build: {
      cssCodeSplit: true,
      minify: 'terser',
      target: 'es2022',
      outDir: '../dist',
      rollupOptions: {
        input: {
          index: path.resolve(__dirname, 'index.html'),
        },
        output: {
          compact: true,
        }
      },
      terserOptions: {
        mangle: {
          eval: true,
          keep_fnames: false,
          keep_classnames: false,
          toplevel: true,
        },
        compress: {
          dead_code: true,
          // drop_console: true,
          drop_debugger: true,
          ecma: 2020,
          if_return: true,
        },
      }
    },
  })
}
