import { Button } from '@blueprintjs/core'
import Keys from '@inject/shared/localstorage/keys'
import { useSessionStorageState } from 'ahooks'

const useMilestonesButton = ({
  hideLabel,
  disabled,
}: {
  hideLabel: boolean
  disabled: boolean
}) => {
  const [open, setOpen] = useSessionStorageState(Keys.MILESTONES_OPEN, {
    defaultValue: false,
  })

  return {
    open,
    setOpen,
    node: (
      <Button
        active={open}
        disabled={disabled}
        icon='flag'
        alignText='left'
        fill
        minimal
        text={!hideLabel && 'Milestones'}
        onClick={() => setOpen(prev => !prev)}
        title='Milestones'
      />
    ),
  }
}

export default useMilestonesButton
