import InjectMessage from '@/actionlog/InjectMessage'
import { Button } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useGetSingleActionLog } from '@inject/graphql/queries/GetSingleActionLog.generated'
import Container from '@inject/shared/components/Container'
import ErrorMessage from '@inject/shared/components/ErrorMessage'
import useInInstructor from '@inject/shared/hooks/useInInstructor'
import type { FC } from 'react'

const wrapper = css`
  display: flex;
  flex-direction: column;
  align-items: flex-start;
  height: 100%;
  width: 100%;
`

interface InjectMessageViewProps {
  teamId: string
  exerciseId: string
  actionLogId: string
  onBack: () => void
}

const InjectMessageView: FC<InjectMessageViewProps> = ({
  teamId,
  exerciseId,
  actionLogId,
  onBack,
}) => {
  const { data } = useGetSingleActionLog({
    variables: {
      logId: actionLogId,
    },
  })
  const inInstructor = useInInstructor()

  if (!data || !data.actionLog) {
    return <ErrorMessage>Log not found</ErrorMessage>
  }

  return (
    <Container makeFullHeight>
      <div className={wrapper}>
        <Button icon='chevron-left' text='Back' minimal onClick={onBack} />
        <InjectMessage
          exerciseId={exerciseId}
          teamId={teamId}
          fill
          actionLog={data.actionLog}
          inInstructor={inInstructor}
        />
      </div>
    </Container>
  )
}

export default InjectMessageView
