import { css } from '@emotion/css'
import type { RestrictedUser } from '@inject/graphql/fragments/RestrictedUser.generated'
import type { FC } from 'react'

const usernameClass = css`
  text-decoration: underline;
`

interface LabelProps {
  user: RestrictedUser
}

const Label: FC<LabelProps> = ({ user }) => {
  const { username, firstName, lastName, group } = user
  const name = `${firstName || ''} ${lastName || ''}`.trim()
  return (
    <>
      <span className={usernameClass}>{username}</span>
      {`${name ? `, ${name}` : ''}${group ? ` (${group})` : ''}`}
    </>
  )
}

export default Label
