import { Dialog, DialogBody, DialogFooter } from '@blueprintjs/core'
import { css, cx } from '@emotion/css'
import type { AuthGroup } from '@inject/graphql/types'
import { maximizedDialog } from '@inject/shared/css/dialog'
import { useCallback, type Dispatch, type FC, type SetStateAction } from 'react'
import useUserTableSelection from './useUserTableSelection'

const body = css`
  display: flex;
  flex-direction: column;
`

interface UserTableSelectionProps {
  open: boolean
  setOpen: Dispatch<SetStateAction<boolean>>
  onAdd: (ids: string[]) => void
  groups: AuthGroup[]
  selectedUsers: string[]
  setSelectedUsers: Dispatch<SetStateAction<string[]>>
}

const UserTableSelection: FC<UserTableSelectionProps> = ({
  open,
  groups,
  setOpen,
  onAdd,
  selectedUsers,
  setSelectedUsers,
}) => {
  const handleCancel = useCallback(() => {
    setOpen(false)
    setSelectedUsers([])
  }, [setOpen, setSelectedUsers])

  const { table, buttons } = useUserTableSelection({
    groups,
    onCancel: handleCancel,
    onAdd,
    selectedUsers,
    setSelectedUsers,
  })

  return (
    <Dialog isOpen={open} onClose={handleCancel} className={maximizedDialog}>
      <DialogBody className={cx(maximizedDialog, body)}>{table}</DialogBody>
      <DialogFooter actions={buttons} />
    </Dialog>
  )
}

export default UserTableSelection
