import type { ValueType } from '@/components/SortableTable/typing'
import type { User } from '@inject/graphql/fragments/User.generated'
import type { AuthGroup } from '@inject/graphql/types'
import type { Dispatch, SetStateAction } from 'react'

export const AUTH_GROUPS: AuthGroup[] = ['ADMIN', 'INSTRUCTOR', 'TRAINEE']

export type Filter<T> = {
  selected: T
  setSelected: Dispatch<SetStateAction<T>>
}

export type Active = { active: boolean; inactive: boolean }

export interface UserProperty {
  id: string
  name: string
  display?: boolean
  getValue: (element: User) => ValueType
}

export const USER_PROPERTIES: UserProperty[] = [
  {
    id: 'id',
    name: 'ID',
    display: false,
    getValue: (user: User) => user.id,
  },
  {
    id: 'username',
    name: 'Username',
    display: true,
    getValue: (user: User) => user.username,
  },
  {
    id: 'firstName',
    name: 'First name',
    display: true,
    getValue: (user: User) => user.firstName,
  },
  {
    id: 'lastName',
    name: 'Last name',
    display: true,
    getValue: (user: User) => user.lastName,
  },
  {
    id: 'group',
    name: 'Group',
    display: true,
    getValue: (user: User) => user.group,
  },
  {
    id: 'active',
    name: 'Active',
    display: true,
    getValue: (user: User) => user.isActive,
  },
  {
    id: 'imported',
    name: 'Imported',
    display: false,
    getValue: (user: User) => user.isImported,
  },
  {
    id: 'createdAt',
    name: 'Created at',
    display: false,
    getValue: (user: User) => new Date(user.dateJoined),
  },
  {
    id: 'lastLogin',
    name: 'Last login',
    display: false,
    getValue: (user: User) =>
      user.lastLogin ? new Date(user.lastLogin) : null,
  },
  {
    id: 'tags',
    name: 'Tags',
    display: true,
    getValue: (user: User) => (user.tags || []).map(tag => tag.name).join(', '),
  },
]
