import type { User } from '@inject/graphql/fragments/User.generated'

interface FilterUsersProps {
  users: User[]
  searchString?: string
}

const useFilterUsers = ({ users, searchString }: FilterUsersProps): User[] => {
  if (!searchString) return users

  const insensitiveSearchString = searchString.toLowerCase()

  return users.filter(
    user =>
      user.username.toLowerCase().includes(insensitiveSearchString) ||
      user.firstName?.toLowerCase().includes(insensitiveSearchString) ||
      user.lastName?.toLowerCase().includes(insensitiveSearchString)
  )
}

export default useFilterUsers
