import { ButtonGroup, Divider } from '@blueprintjs/core'
import Reloader from '@inject/graphql/components/Reloader'
import responsiveButtonGroup from '@inject/shared/css/responsiveButtonGroup'
import type { FC } from 'react'
import useDeleteUsers from '../useDeleteUsers'
import useRegenerateCredentials from '../useResetCredentials'

interface OptionsProps {
  userId: string
  onRefetch: () => void
  onDelete: () => void
}

const Options: FC<OptionsProps> = ({ userId, onRefetch, onDelete }) => {
  const { button: deleteButton, alert: deleteAlert } = useDeleteUsers({
    userIds: [userId],
    onConfirm: onDelete,
  })
  const { button: resetButton, alert: resetAlert } = useRegenerateCredentials({
    userIds: [userId],
  })

  return (
    <>
      <ButtonGroup minimal className={responsiveButtonGroup}>
        {resetButton && (
          <>
            {resetButton}
            <Divider />
          </>
        )}
        {deleteButton && (
          <>
            {deleteButton}
            <Divider />
          </>
        )}
        <Reloader onRefetch={onRefetch} />
      </ButtonGroup>

      {deleteAlert}
      {resetAlert}
    </>
  )
}

export default Options
