import { useParams } from '@/router'
import { useSetPageTitle } from '@/utils'
import TraineeView from '@/views/TraineeView'
import { Outlet } from 'react-router-dom'

const Layout = () => {
  const { exerciseId, teamId, threadId } = useParams(
    '/trainee/:exerciseId/:teamId/:channelId/email/:tab/:threadId'
  )
  useSetPageTitle('Trainee')

  return (
    <TraineeView
      exerciseId={exerciseId}
      teamId={teamId}
      selectedThreadId={threadId}
    >
      <Outlet />
    </TraineeView>
  )
}

export default Layout
