import InjectLogo from '@/assets/inject-logo--vertical-black.svg?react'
import Login from '@/logic/Login'
import { useSetPageTitle } from '@/utils'
import { css } from '@emotion/css'
import Container from '@inject/shared/components/Container'

const page = css`
  height: 100%;
  display: flex;
  flex-direction: column;
`

const logo = css`
  width: 100%;
  height: 20rem;
`

const LoginPage = () => {
  useSetPageTitle('Login')

  return (
    <Container className={page}>
      <InjectLogo className={logo} />
      <Login />
    </Container>
  )
}

export default LoginPage
