import { useParams } from '@/router'
import { useSetPageTitle, useStaffBoundary } from '@/utils'
import InstructorView from '@/views/InstructorView'
import { Outlet } from 'react-router-dom'

const Layout = () => {
  const { exerciseId, teamId, threadId } = useParams(
    '/instructor/:exerciseId/:teamId/:channelId/email/:tab/:threadId'
  )
  useStaffBoundary()
  useSetPageTitle('Instructor')

  return (
    <InstructorView
      exerciseId={exerciseId}
      teamId={teamId}
      selectedThreadId={threadId}
    >
      <Outlet />
    </InstructorView>
  )
}

export default Layout
