import InjectLogo from '@/assets/inject-logo--vertical-black.svg?react'
import StaffSelector from '@/logic/StaffSelector'
import TeamSelector from '@/logic/TeamSelector'
import { useNavigate } from '@/router'
import { useSetPageTitle } from '@/utils'
import { Checkbox, Collapse } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useAuthIdentity } from '@inject/graphql/auth'
import Container from '@inject/shared/components/Container'
import { useEffect, useState } from 'react'

const index = css`
  min-height: 100%;
  height: fit-content;
  display: flex;
  flex-direction: column;
  justify-content: center;
`

const logo = css`
  height: 20rem;
  width: fit-content;

  @media (max-width: 40rem) {
    height: 15rem;
  }
`

const intro = css`
  display: flex;
  flex-direction: row-reverse;
  justify-content: center;
  align-items: center;
  gap: 1rem;
  text-align: center;

  @media (max-width: 40rem) {
    flex-direction: column;
    gap: 0;
    margin-bottom: 1rem;
  }
`

const Index = () => {
  useSetPageTitle('')
  const { isActive, isStaff, isSuperuser, isLogged, loading } =
    useAuthIdentity()
  const nav = useNavigate()
  useEffect(() => {
    if (!isLogged && !loading) {
      nav('/login')
    }
  }, [isLogged, nav, loading])
  const [enableTrainee, setEnableTrainee] = useState(false)

  return (
    <Container className={index}>
      <div className={intro}>
        <InjectLogo className={logo} />
        <div>
          <h1>Welcome</h1>
          <p>
            Embark on a journey of strategic crisis management and incident
            response. Our scenarios will enhance your skills to boost the
            resilience of your organization.
          </p>
        </div>
      </div>

      {isActive && !isStaff && (
        <>
          <h2>Select your team</h2>
          <TeamSelector />
          <br />
        </>
      )}
      {(isStaff || isSuperuser) && (
        <>
          <h2>Select your role</h2>
          <br />
          <StaffSelector enableRefresh={!enableTrainee} />
          <br />
          <Checkbox
            checked={enableTrainee}
            onChange={e => setEnableTrainee(e.target.checked)}
          >
            Enable trainee team list (allows you to enter exercises as a trainee
            for testing purposes)
          </Checkbox>
          <Collapse isOpen={enableTrainee} keepChildrenMounted={false}>
            <TeamSelector />
          </Collapse>
        </>
      )}
    </Container>
  )
}

export default Index
