import GitVersion from '@/components/GitVersion'
import DefinitionManager from '@/exercisepanel/DefinitionManager'
import ExerciseManager from '@/exercisepanel/ExerciseManager'
import ExportImport from '@/exercisepanel/ExportImport'
import { css } from '@emotion/css'
import useAuthIdentity from '@inject/graphql/auth'

const limitedHeight = css`
  max-height: 70vh;
  overflow-y: auto;
`

const ExercisePanel = () => {
  const { isSuperuser } = useAuthIdentity()

  return (
    <>
      {isSuperuser && <ExportImport />}
      <DefinitionManager className={limitedHeight} />
      <ExerciseManager className={limitedHeight} />
      <GitVersion />
    </>
  )
}

export default ExercisePanel
