import useNotificationLimit from '@/clientsettings/NotificationLimit/useNotificationLimit'
import {
  makeVar,
  useLocalStorageReactiveVar,
} from '@inject/graphql/client/reactive'
import Keys from '@inject/shared/localstorage/keys'
import type { NotificationProps } from '@inject/shared/notification/typing'

const notificationsReactiveVar = makeVar<NotificationProps[]>([])

const useNotificationStorage = () => {
  const [notificationLimit] = useNotificationLimit()
  return useLocalStorageReactiveVar(
    notificationsReactiveVar,
    Keys.NOTIFICATIONS,
    {
      serializer: value => JSON.stringify(value.slice(-notificationLimit)),
      deserializer: value => JSON.parse(value).slice(-notificationLimit),
    }
  )
}

export default useNotificationStorage
