import '@fontsource/inter'
import 'normalize.css'
import React from 'react'
import ReactDOM from 'react-dom/client'
import './global.scss'

import { OverlaysProvider } from '@blueprintjs/core'
import Application from './application'
import './icons'
import NotificationEngine from './notifications/NotificationEngine'

declare global {
  interface Window {
    VITE_HTTPS_HOST: string
  }
}

ReactDOM.createRoot(document.getElementById('root') as HTMLElement).render(
  <React.StrictMode>
    <OverlaysProvider>
      <NotificationEngine>
        <Application />
      </NotificationEngine>
    </OverlaysProvider>
  </React.StrictMode>
)
