import { useNavigate } from '@/router'
import useApolloClient from '@inject/graphql/client/useApolloClient'
import { useLogout } from '@inject/graphql/mutations/Logout.generated'
import { useNotifyContext } from '@inject/shared/notification/contexts/NotifyContext'

const useHandleLogout = () => {
  const [logout] = useLogout()
  const nav = useNavigate()
  const apollo = useApolloClient()
  const { clearNotify } = useNotifyContext()

  return async () => {
    await logout()
    document.cookie =
      'sessionid=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;'
    localStorage.clear()
    apollo.clearStore()
    apollo.cache.reset()
    clearNotify()
    nav('/login')
  }
}

export default useHandleLogout
