import LinkButton from '@/components/LinkButton'
import { type FC } from 'react'
import { matchPath } from 'react-router-dom'

interface LearningObjectivesButtonProps {
  exerciseId: string | undefined
  teamId: string | undefined
  hideLabel: boolean
  pathname: string
}

const LearningObjectivesButton: FC<LearningObjectivesButtonProps> = ({
  exerciseId,
  teamId,
  hideLabel,
  pathname,
}) => (
  <LinkButton
    link={
      exerciseId === undefined || teamId === undefined
        ? undefined
        : [
            '/instructor/:exerciseId/:teamId/learning-objectives',
            { params: { exerciseId, teamId } },
          ]
    }
    button={{
      icon: 'learning',
      active:
        matchPath(
          {
            path: '/instructor/:exerciseId/:teamId/learning-objectives',
            end: false,
          },
          pathname
        ) !== null,
      alignText: 'left',
      fill: true,
      disabled: !teamId || !exerciseId,
      minimal: true,
      text: !hideLabel && 'Learning objectives',
      title: 'Learning objectives',
      style: { whiteSpace: 'nowrap' },
    }}
  />
)

export default LearningObjectivesButton
