import { Colors, Section, SectionCard } from '@blueprintjs/core'
import { Tick } from '@blueprintjs/icons'
import { css, cx } from '@emotion/css'
import type { TeamLearningObjective } from '@inject/graphql/fragments/TeamLearningObjective.generated'
import type { FC } from 'react'
import LearningActivity from './LearningActivity'
import { reached } from './classes'

const objectiveClass = css`
  flex-shrink: 0;
`

const activities = css`
  display: flex;
  flex-direction: column;
  gap: 1rem;
`

interface LearningObjectiveProps {
  objective: TeamLearningObjective
  teamId: string
}

const LearningObjective: FC<LearningObjectiveProps> = ({
  objective,
  teamId,
}) => (
  <Section
    title={objective.objective.name}
    subtitle={objective.objective.tags}
    collapsible
    className={cx({ [objectiveClass]: true, [reached]: objective.reached })}
    icon={objective.reached ? <Tick color={Colors.GREEN3} /> : undefined}
  >
    <SectionCard className={activities}>
      {objective.activities.map(activity => (
        <LearningActivity
          key={activity.id}
          activity={activity}
          teamId={teamId}
        />
      ))}
    </SectionCard>
  </Section>
)

export default LearningObjective
