import { CardList, Colors, Section, SectionCard } from '@blueprintjs/core'
import { Tick } from '@blueprintjs/icons'
import type { TeamLearningActivity } from '@inject/graphql/fragments/TeamLearningActivity.generated'
import type { FC } from 'react'
import MilestoneIndicator from '../InstructorMilestones/MilestoneIndicator'
import { reached } from './classes'

interface LearningActivityProps {
  activity: TeamLearningActivity
  teamId: string
}

const LearningActivity: FC<LearningActivityProps> = ({ activity, teamId }) => (
  <Section
    title={activity.activity.name}
    subtitle={activity.activity.tags}
    className={activity.reached ? reached : undefined}
    icon={activity.reached ? <Tick color={Colors.GREEN3} /> : undefined}
  >
    <SectionCard>
      <CardList bordered={false}>
        {activity.milestoneStates
          .sort((a, b) => a.milestone.name.localeCompare(b.milestone.name))
          .map(milestoneState => (
            <MilestoneIndicator
              key={milestoneState.id}
              milestone={milestoneState}
              teamId={teamId}
            />
          ))}
      </CardList>
    </SectionCard>
  </Section>
)

export default LearningActivity
