import { CardList } from '@blueprintjs/core'
import { useGetTeamMilestones } from '@inject/graphql/queries/GetTeamMilestones.generated'
import notEmpty from '@inject/shared/utils/notEmpty'
import { type FC } from 'react'
import MilestoneIndicator from './MilestoneIndicator'

interface InstructorMilestonesProps {
  teamId: string
  reached: boolean
}

const InstructorMilestones: FC<InstructorMilestonesProps> = ({
  teamId,
  reached,
}) => {
  const { data } = useGetTeamMilestones({ variables: { teamId } })

  const milestones = (data?.teamMilestones || [])
    .filter(notEmpty)
    .filter(
      milestone =>
        (reached && milestone.reached) || (!reached && !milestone.reached)
    )
    .sort((a, b) => a.milestone.name.localeCompare(b.milestone.name))

  return (
    <CardList bordered={false} compact>
      {milestones.map(milestone => (
        <MilestoneIndicator
          milestone={milestone}
          key={milestone.milestone.name}
          teamId={teamId}
        />
      ))}
    </CardList>
  )
}

export default InstructorMilestones
