import { Checkbox, Collapse, NumericInput } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { Dispatch, FC, SetStateAction } from 'react'

const main = css`
  display: flex;
  flex-direction: column;
`

interface OverlayFormProps {
  isOverlay: boolean
  setIsOverlay: Dispatch<SetStateAction<boolean>>
  duration: number | undefined
  setDuration: Dispatch<SetStateAction<number | undefined>>
}

const OverlayForm: FC<OverlayFormProps> = ({
  isOverlay,
  setIsOverlay,
  duration,
  setDuration,
}) => (
  <div className={main}>
    <Checkbox
      style={{ margin: '0' }}
      checked={isOverlay}
      title='Send as overlay'
      label='Send as overlay'
      onClick={() => {
        if (isOverlay) setDuration(undefined)
        setIsOverlay(prev => !prev)
      }}
    />
    <Collapse isOpen={isOverlay}>
      <NumericInput
        value={duration}
        onValueChange={value => setDuration(value)}
        placeholder='Duration in minutes'
        title='Duration in minutes'
        fill
        min={1}
        leftIcon='time'
      />
    </Collapse>
  </div>
)

export default OverlayForm
