import { AnchorButton, Button, ButtonGroup, Section } from '@blueprintjs/core'
import { useHost } from '@inject/graphql/connection/host'
import { exportImportUrl } from '@inject/shared/config'
import { useState } from 'react'
import ImportDialog from './ImportDialog'

const ExportImport = () => {
  const host = useHost()
  const [isImportOpen, setIsImportOpen] = useState(false)

  return (
    <>
      <Section
        title='Export and import'
        subtitle={
          <span>
            Exported data include <b>all definitions, exercises, and users</b>
          </span>
        }
        rightElement={
          <ButtonGroup>
            <AnchorButton
              icon='export'
              href={exportImportUrl(host || '')}
              target='_blank'
              rel='noreferrer'
            >
              Export
            </AnchorButton>
            <Button
              active={isImportOpen}
              onClick={() => setIsImportOpen(true)}
              icon='import'
            >
              Import
            </Button>
          </ButtonGroup>
        }
      />

      <ImportDialog
        isOpen={isImportOpen}
        onClose={() => setIsImportOpen(false)}
      />
    </>
  )
}

export default ExportImport
