import { Button, Section, SectionCard } from '@blueprintjs/core'
import { useState, type FC } from 'react'
import ExerciseCreator from './ExerciseCreator'
import ExerciseList from './components/ExerciseList'

interface ExerciseManagerProps {
  className?: string
}

const ExerciseManager: FC<ExerciseManagerProps> = ({ className }) => {
  const [creatorOpen, setCreatorOpen] = useState(false)

  return (
    <>
      <Section
        title='Exercises'
        rightElement={
          <Button
            onClick={event => {
              event.stopPropagation()
              setCreatorOpen(true)
            }}
            active={creatorOpen}
            icon='add'
          >
            Create
          </Button>
        }
      >
        <SectionCard>
          <ExerciseList className={className} />
        </SectionCard>
      </Section>

      <ExerciseCreator open={creatorOpen} setOpen={setCreatorOpen} />
    </>
  )
}

export default ExerciseManager
