import { Alert } from '@blueprintjs/core'
import type { PropsWithChildren } from 'react'
import { type Dispatch, type FC, type SetStateAction } from 'react'

interface DeleteAlertProps extends PropsWithChildren {
  open: boolean
  setOpen: Dispatch<SetStateAction<boolean>>
  onDelete: () => void
  loading?: boolean
}

const DeleteAlert: FC<DeleteAlertProps> = ({
  open,
  setOpen,
  children,
  onDelete,
  loading,
}) => (
  <Alert
    isOpen={open}
    canEscapeKeyCancel
    canOutsideClickCancel
    cancelButtonText='Cancel'
    onCancel={() => setOpen(false)}
    confirmButtonText='Delete'
    icon='trash'
    intent='danger'
    onConfirm={onDelete}
    onClose={() => setOpen(false)}
    loading={loading}
  >
    {children}
  </Alert>
)

export default DeleteAlert
