import type { EmailSelection } from '@/analyst/utilities'
import type { LinkType } from '@/components/LinkButton'
import type { EmailThread } from '@inject/graphql/fragments/EmailThread.generated'
import type { FC } from 'react'
import TeamEmails from '.'

interface TraineeTeamEmailsProps {
  exerciseId: string
  teamId: string
  emailThreads: EmailThread[]
  selectedTab: EmailSelection
  receivedLink: LinkType
  sentLink: LinkType
  draftsLink: LinkType
  selectedEmailThreadId: string | undefined
  onClick: (emailThread: EmailThread) => void
}

const TraineeTeamEmails: FC<TraineeTeamEmailsProps> = ({
  exerciseId,
  teamId,
  emailThreads,
  selectedTab,
  receivedLink,
  sentLink,
  draftsLink,
  selectedEmailThreadId,
  onClick,
}) => {
  const selectedEmailThread = emailThreads.find(
    emailThread => emailThread.id === selectedEmailThreadId
  )

  return (
    <TeamEmails
      exerciseId={exerciseId}
      teamId={teamId}
      emailThreads={emailThreads}
      selectedTab={selectedTab}
      receivedLink={receivedLink}
      sentLink={sentLink}
      draftsLink={draftsLink}
      selectedEmailThread={selectedEmailThread}
      onClick={onClick}
      allowComposing
      allowReplying
      allowForwarding
    />
  )
}

export default TraineeTeamEmails
