import { Button, Classes } from '@blueprintjs/core'
import { cx } from '@emotion/css'
import type { FC, ReactNode } from 'react'

interface ThreadHeaderCardProps {
  title: string
  subtitle?: ReactNode
  allowReplying: boolean
  replyButtonTitle?: string
  onReply?: () => void
}

const ThreadHeaderCard: FC<ThreadHeaderCardProps> = ({
  title,
  subtitle = '',
  allowReplying,
  replyButtonTitle,
  onReply,
}) => (
  <div style={{ display: 'flex', padding: '0.5rem 1rem 0' }}>
    <div>
      <h6 className={cx(Classes.HEADING, Classes.SECTION_HEADER_TITLE)}>
        {title}
      </h6>
      <div className={cx(Classes.TEXT_MUTED, Classes.SECTION_HEADER_SUB_TITLE)}>
        {subtitle}
      </div>
    </div>
    <div className={Classes.SECTION_HEADER_RIGHT}>
      <Button
        minimal
        intent='primary'
        text='Reply'
        icon='key-enter'
        onClick={onReply}
        disabled={!allowReplying}
        title={replyButtonTitle}
      />
    </div>
  </div>
)

export default ThreadHeaderCard
