import { EntityTitle, Tooltip } from '@blueprintjs/core'
import { css } from '@emotion/css'
import type { EmailParticipant } from '@inject/graphql/fragments/EmailParticipant.generated'
import type { FC } from 'react'

const title = css`
  gap: 0;
`

interface InstructorAddressLabelProps {
  participant: EmailParticipant
}

const InstructorAddressLabel: FC<InstructorAddressLabelProps> = ({
  participant,
}) =>
  participant.definitionAddress ? (
    <Tooltip content={participant.definitionAddress.description}>
      <EntityTitle
        className={title}
        icon='small-info-sign'
        title={participant.address}
      />
    </Tooltip>
  ) : (
    <EntityTitle title={participant.address} />
  )

export default InstructorAddressLabel
