import type { EmailSelection } from '@/analyst/utilities'
import type { LinkType } from '@/components/LinkButton'
import type { EmailThread } from '@inject/graphql/fragments/EmailThread.generated'
import type { FC } from 'react'
import TeamEmails from '.'

interface InstructorTeamEmailsProps {
  exerciseId: string
  teamId: string
  emailThreads: EmailThread[]
  selectedTab: EmailSelection
  receivedLink: LinkType
  sentLink: LinkType
  draftsLink: LinkType
  selectedEmailThreadId: string | undefined
  onClick: (emailThread: EmailThread) => void
}

const InstructorTeamEmails: FC<InstructorTeamEmailsProps> = ({
  exerciseId,
  teamId,
  emailThreads,
  selectedTab,
  receivedLink,
  sentLink,
  draftsLink,
  selectedEmailThreadId,
  onClick,
}) => {
  const selectedEmailThread = emailThreads.find(
    emailThread => emailThread.id === selectedEmailThreadId
  )

  const replyDisabled =
    selectedEmailThread !== undefined &&
    !selectedEmailThread.participants.some(
      participant => participant.definitionAddress
    )

  return (
    <TeamEmails
      exerciseId={exerciseId}
      teamId={teamId}
      emailThreads={emailThreads}
      selectedTab={selectedTab}
      receivedLink={receivedLink}
      sentLink={sentLink}
      draftsLink={draftsLink}
      selectedEmailThread={selectedEmailThread}
      onClick={onClick}
      allowComposing
      allowReplying={!replyDisabled}
      inInstructor
      replyButtonTitle={
        replyDisabled ? "You can't reply to emails between teams" : undefined
      }
      allowForwarding
    />
  )
}

export default InstructorTeamEmails
