import { useGetTeamEmailParticipant } from '@inject/graphql/queries/GetTeamEmailParticipant.generated'
import type { FC } from 'react'
import EmailFormOverlay from '.'

interface TraineeEmailFormOverlayProps {
  teamId: string
  exerciseId: string
}

const TraineeEmailFormOverlay: FC<TraineeEmailFormOverlayProps> = ({
  teamId,
  exerciseId,
}) => {
  const { data, loading, error } = useGetTeamEmailParticipant({
    variables: {
      teamId,
    },
    skip: !teamId,
  })

  return (
    <EmailFormOverlay
      teamId={teamId}
      emailForm='trainee'
      exerciseId={exerciseId}
      teamAddress={data?.teamEmailParticipant?.address || ''}
      loading={loading || !data?.teamEmailParticipant?.address}
      error={error}
    />
  )
}

export default TraineeEmailFormOverlay
