import type { FC } from 'react'
import EmailFormOverlay from '.'

interface InstructorEmailFormOverlayProps {
  teamId: string
  exerciseId: string
}

const InstructorEmailFormOverlay: FC<InstructorEmailFormOverlayProps> = ({
  teamId,
  exerciseId,
}) => (
  <EmailFormOverlay
    teamId={teamId}
    emailForm='instructor'
    exerciseId={exerciseId}
  />
)

export default InstructorEmailFormOverlay
