import type { EmailParticipant } from '@inject/graphql/fragments/EmailParticipant.generated'
import type { EmailThread } from '@inject/graphql/fragments/EmailThread.generated'
import type { Dispatch, SetStateAction } from 'react'
import type { FormState } from './useFormState'

export type EmailFormProps = {
  exerciseId: string
  emailThread?: EmailThread
  teamId: string
  onSuccess: () => void
  formState: FormState
}

export type OnSendEmailInput = {
  threadId: string
  allowActivateMilestone: boolean
}

export type HeaderAreaProps = (
  | {
      // new thread
      emailThread?: never
      selectedContacts: string[]
      setSelectedContacts: Dispatch<SetStateAction<string[]>>
      bccSelectedContacts: string[]
      setBccSelectedContacts: Dispatch<SetStateAction<string[]>>
      subject: string | undefined
      setSubject: Dispatch<SetStateAction<string | undefined>>
    }
  | {
      // existing thread
      emailThread: EmailThread
      selectedContacts?: never
      setSelectedContacts?: never
      bccSelectedContacts?: never
      setBccSelectedContacts?: never
      subject?: never
      setSubject?: never
    }
) & {
  contacts: EmailParticipant[]
  exerciseId: string
}
