import { Classes, Tag } from '@blueprintjs/core'
import ColorBox from '@inject/shared/components/ColorBox'
import { useMemo, type FC } from 'react'

interface TeamLabelProps {
  hideLabel?: boolean
  teamId: string
  teamName: string
  teamRole?: string
  exerciseName?: string
  inactive?: boolean
}

const TeamLabel: FC<TeamLabelProps> = ({
  hideLabel,
  teamId,
  teamName,
  teamRole,
  exerciseName,
  inactive,
}) => {
  const label = useMemo(
    () => (
      <div>
        <div>{teamName}</div>
        {teamRole && (
          <div className={Classes.TEXT_MUTED}>{`role: ${teamRole}`}</div>
        )}
        {exerciseName && (
          <div
            className={Classes.TEXT_MUTED}
          >{`exercise: ${exerciseName}`}</div>
        )}
      </div>
    ),
    [exerciseName, teamName, teamRole]
  )

  const colorbox = useMemo(
    () => (
      <ColorBox
        style={{
          // the size of Blueprint icons
          width: '16px',
          height: '16px',
          // TODO: this should be the same as the margin of an icon in a button
          marginRight: hideLabel ? undefined : '7px',
        }}
        id={Number(teamId)}
      />
    ),
    [hideLabel, teamId]
  )

  const content = useMemo(() => {
    if (hideLabel) {
      return colorbox
    }

    return (
      <>
        {colorbox}
        {label}
        {inactive && (
          <Tag style={{ marginLeft: '1ch' }} minimal intent='warning'>
            inactive
          </Tag>
        )}
      </>
    )
  }, [colorbox, hideLabel, inactive, label])

  return (
    <div
      style={{
        display: 'flex',
        justifyContent: hideLabel ? 'center' : 'flex-start',
        alignItems: 'center',
      }}
    >
      {content}
    </div>
  )
}

export default TeamLabel
