import HealthCheck from '@/analyst/HealthCheck'
import TimeLeft from '@/analyst/TimeLeft'
import { css } from '@emotion/css'
import type { Team } from '@inject/graphql/fragments/Team.generated'
import type { FC } from 'react'
import TeamLabel from '../TeamLabel'

const header = css`
  padding: 0.25rem 0.5rem;
  display: flex;
  gap: 0.5rem;
  justify-content: center;
  align-items: center;
`

interface StatusProps {
  small: boolean
  exerciseRunning: boolean
  showTime: boolean
  team?: Team
  hideLabel?: boolean
}

const Status: FC<StatusProps> = ({
  small,
  exerciseRunning,
  showTime,
  team,
  hideLabel,
}) => (
  <div
    style={{
      display: 'flex',
      flexDirection: 'column',
      gap: '0.5rem',
      alignItems: 'center',
    }}
  >
    <div className={header}>
      {!small && (!exerciseRunning || !showTime) && <span>Backend:</span>}
      <HealthCheck />
      {exerciseRunning && showTime && <TimeLeft />}
    </div>
    {team && (
      <TeamLabel
        teamId={team.id}
        teamName={team.name}
        hideLabel={hideLabel}
        exerciseName={team.exercise.name}
        teamRole={team.role}
      />
    )}
  </div>
)

export default Status
