import type { ValueType } from './typing'

export const ascSorting = (a: ValueType, b: ValueType) => {
  if (a === null && b === null) return 0
  if (a === null) return 1
  if (b === null) return -1

  if (typeof a === 'string' || typeof b === 'string') {
    return a
      .toString()
      .toLocaleLowerCase()
      .localeCompare(b.toString().toLocaleLowerCase())
  }

  if (typeof a === 'boolean' && typeof b === 'boolean') {
    if (a === b) return 0
    if (b) return 1
    return -1
  }

  if (a < b) return -1
  if (a > b) return 1
  return 0
}

export const descSorting = (a: ValueType, b: ValueType) => -ascSorting(a, b)

export const defaultFormatValue = (value: ValueType) => {
  if (value === null) return ''
  if (typeof value === 'string') return value
  if (typeof value === 'number') return value.toString()
  if (typeof value === 'boolean') return value ? 'yes' : 'no'
  return `${value.toISOString().substring(0, 10)} ${value.toLocaleTimeString()}`
}
