import { Button } from '@blueprintjs/core'
import Keys from '@inject/shared/localstorage/keys'
import { useSessionStorageState } from 'ahooks'

const useHideButton = () => {
  const [hide, setHide] = useSessionStorageState(Keys.HIDE_SIDEBAR, {
    defaultValue: false,
  })

  return {
    hide: hide || false,
    setHide,
    node: (
      <Button
        icon={hide ? 'menu-open' : 'menu-closed'}
        alignText='left'
        fill
        minimal
        text={!hide && 'Hide sidebar'}
        onClick={() => setHide(prev => !prev)}
        style={{ whiteSpace: 'nowrap' }}
        title={`${hide ? 'Show' : 'Hide'} sidebar`}
      />
    ),
  }
}

export default useHideButton
