import { Divider } from '@blueprintjs/core'
import { css, cx } from '@emotion/css'
import type { FC, ReactNode } from 'react'
import InjectLogo from '../../assets/inject-logo.svg?react'
import NoBorderDivider from './NoBorderDivider'

const container = css`
  display: flex;
  height: 100%;
`

const sidebar = css`
  flex: 1;
  margin: 0.25rem 0;
  overflow-y: auto;
`

const sectionName = css`
  margin: 0 0 0.25rem 0.5rem;
`

const sidebarTitle = css`
  margin: 0 0 0.25rem 0.5rem;
  text-align: center;
`

export interface Section {
  name?: string
  node: ReactNode
}

interface SidebarProps {
  position?: 'left' | 'right'
  hideNames?: boolean
  sections: Section[]
  showLogo?: boolean
  title?: string
  className?: string
}

const Sidebar: FC<SidebarProps> = ({
  position,
  sections,
  showLogo,
  hideNames,
  title,
  className,
}) => (
  <div className={cx(container, ...(className ? [className] : []))}>
    {position === 'right' && <Divider />}
    {position === 'left' && <NoBorderDivider />}

    <div className={sidebar}>
      {title && (
        <div>
          <h2 className={sidebarTitle}>{title}</h2>
          <Divider />
        </div>
      )}

      {showLogo && (
        <>
          <InjectLogo
            style={{
              width: '5rem',
              height: 'auto',
              padding: '0.25rem 0.5rem',
              display: 'block',
              margin: 'auto',
            }}
          />

          <Divider />
        </>
      )}

      {sections.map((section, index) => (
        <div key={index}>
          {!hideNames && section.name && (
            <h3 className={sectionName}>{section.name}</h3>
          )}
          {section.node}
          {index < sections.length - 1 && <Divider />}
        </div>
      ))}
    </div>

    {position === 'left' && <Divider />}
    {position === 'right' && <NoBorderDivider />}
  </div>
)

export default Sidebar
