import { version } from '@/constants'
import { Callout, Spinner, SpinnerSize } from '@blueprintjs/core'
import { css } from '@emotion/css'
import { useHost } from '@inject/graphql/connection/host'
import { httpHello } from '@inject/shared/config'
import { useEffect, useState } from 'react'

const spinner = css`
  /* causes ever-changing overflows without the padding */
  padding: 0.2rem;
  width: max-content;
  display: inline-block;
`

const GitVersion = () => {
  const [data, setData] = useState<null | string>(null)
  const host = useHost()

  useEffect(() => {
    fetch(httpHello(host || '')).then(async e => {
      setData(JSON.parse(await e.text())['version'])
    })
  }, [setData, host])

  return (
    <Callout intent='none'>
      <p>
        Frontend version: <code>{version}</code>
      </p>
      <p>
        Backend version:{' '}
        {data ? (
          <code>{data}</code>
        ) : (
          <Spinner size={SpinnerSize.SMALL} className={spinner} />
        )}
      </p>
    </Callout>
  )
}

export default GitVersion
