import { Classes, Icon } from '@blueprintjs/core'
import { css, cx } from '@emotion/css'
import type { FC, MouseEventHandler, PropsWithChildren } from 'react'

const fileButton = css`
  max-width: 100%;
  display: flex;
  align-items: center;
  gap: 0.5rem;
`

const ellipsize = css`
  overflow: hidden;
  text-overflow: ellipsis;
`

const clickable = css`
  cursor: pointer;
`

interface FileButtonComponentProps extends PropsWithChildren {
  href?: string
  onClick?: MouseEventHandler<HTMLAnchorElement>
  onDelete?: () => void
}

const FileButtonComponent: FC<FileButtonComponentProps> = ({
  href,
  onClick,
  children,
  onDelete,
}) => (
  <div className={fileButton}>
    <Icon
      icon={onDelete ? 'cross' : 'paperclip'}
      onClick={onDelete}
      className={cx({ [Classes.TEXT_MUTED]: true, [clickable]: !!onDelete })}
      title={onDelete ? 'Remove attachment' : 'Attachment'}
    />
    <a
      className={ellipsize}
      onClick={onClick}
      href={href}
      target='_blank'
      rel='noreferrer'
    >
      {children}
    </a>
  </div>
)

export default FileButtonComponent
